/*
 * @(#)ClassListener.java  1.0  30. Januar 2004
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */


package ch.hslu.cm.oo.objectmodel;

import java.util.*;
/**
 * The Listener interface for {@link OMObjectEvent}.
 *
 * @author  Werner Randelshofer
 * @version 1.0 30. Januar 2004  Created.
 */
public interface OMObjectListener extends EventListener {
    public void nameChanged(OMObjectEvent event);
    public void stateChanged(OMObjectEvent event);
    public void classChanged(OMObjectEvent event);
    
    void linkAdded(OMObjectEvent evt);
    void linkRemoved(OMObjectEvent evt);
    void methodEntered(OMObjectEvent evt);
    void methodExited(OMObjectEvent evt);
    void transmittingMessage(OMObjectEvent evt);
    void messageTransmitted(OMObjectEvent evt);
    void transmittingResponse(OMObjectEvent evt);
    void responseTransmitted(OMObjectEvent evt);
    void constructorEntered(OMObjectEvent evt);
    void constructorExited(OMObjectEvent evt);    
}
